/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 � i-net software 1998-2013

*/
using System;
using System.Drawing;
using Inet.Viewer.Data;


namespace Inet.Viewer
{
    /// <summary>
    /// A single PageView responsible for displaying a single page of the report.
    /// </summary>
    public interface IPageView
    {

        /// <summary>
        /// Reference to the ReportView that will be displayed by this IPageView
        /// </summary>
        IReportView ReportView { get; set; }

        /// <summary>
        /// Shows an error - this will cause this error to be dealt with for the scroll view (usually by passing
        /// the error on to this element's parent, showing an error box and/or logging a message).
        /// </summary>
        /// <param name="th"> The Exception object of the error which has occurred. </param>
        void ShowError(Exception th);

        /// <summary>
        /// Returns the page this page view currently is showing. (1-based) </summary>
        /// <returns> The page this page view currently is showing. </returns>
        int Page { get; set; }



        /// <returns> Whether prompts are currently being requested </returns>
        bool PromptDialogOpen { get; }

        /// <summary>       
        /// Loads the page and renders it into an image        
        /// </summary>
        void PaintImage(bool refresh);

        /*
  /// <param name="prompts"> Called when a PromptRequestException occurs, that is, the server requires prompt values in order to
  /// render the report. Which prompts and their data are stored in PromptData objects. </param>
        void RequestPrompts(PromptData[] prompts);*/


        /// <summary>
        /// 
        /// </summary>
        PageInfo PageInfo { get; }
    }
}